<?php

// W programie zostaa wykorzystana funkcja Markdown dostpna pod adresem
// http://www.michelf.com/projects/php-markdown/
// Umoliwia ona opisywanie treci w sposb charakterystyczny dla serwisw Wiki.
require_once 'markdown.php';

// Katalog, w ktrym przechowywane s strony Wiki.
// Serwer WWW musi mie moliwo zapisywania w nim danych.
define('PAGEDIR',dirname(__FILE__) . '/strony');

// Pobranie nazwy strony lub wykorzystanie nazwy domylnej
$page = isset($_GET['page']) ? $_GET['page'] : 'Strona gwna';

// Ustalenie celu uruchomienia skryptu  wywietlenie formularza edycyjnego, zapis 
// formularza edycyjnego lub wywietlenie strony

// Wywietlenie danego formularza edycyjnego
if (isset($_GET['edit'])) {
    pageHeader($page);
    edit($page);
    pageFooter($page, false);
}
// Zapis przesanego formularza edycyjnego
else if (isset($_POST['edit'])) {
    file_put_contents(pageToFile($_POST['page']), $_POST['contents']);
    // Skierowanie do standardowego widoku zmodyfikowanej strony
    header('Location: http://'.$_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME'] .
           '?page='.urlencode($_POST['page']));
    exit();
}
// Wywietlenie strony
else {
    pageHeader($page);
    // Jeli strona istnieje, zostanie wywietlona wraz z odsyaczem "Edycja" w stopce
    if (is_readable(pageToFile($page))) {
        // Pobranie treci strony z pliku, w ktrym jest zapisana
        $text = file_get_contents(pageToFile($page));
        // Przeksztacenie skadni Markdown (za pomoc funkcji Markdown()
        // z biblioteki markdown.php)
        $text = Markdown($text);
        // Przeksztacenie cigw [odsyaczy] w odsyacze do innych stron Wiki
        $text = wikiLinks($text);
        // Wywietlenie strony
        echo $text;
        // Wywietlenie stopki
        pageFooter($page, true);
    }
    // Jeli strona nie istnieje, zostanie wywietlony fomularz edycyjny
    // oraz stopka bez odsyacza "Edycja"
    else {
        edit($page, true);
        pageFooter($page, false);
    }
}

// Nagwek strony -- nieskomplikowany, zawierajcy jedynie tytu oraz standardowe
// ozdobniki HTML
function pageheader($page) { ?>
<html>
<head>
<title>Wiki: <?php echo htmlentities($page) ?></title>
</head>
<body>
<h1><?php echo htmlentities($page) ?></h1>
<hr/>
<?php
}

// Stopka strony  data ostatniej modyfikacji, opcjonalny odsyacz "Edycja" oraz 
// odsyacz do gwnej strony serwisu
function pageFooter($page, $displayEditLink) {
    $timestamp = @filemtime(pageToFile($page));
    if ($timestamp) {
        $lastModified = strftime('%c', $timestamp);
    } else {
        $lastModified = 'Nigdy';
    }
    if ($displayEditLink) {
        $editLink = ' - <a href="?page='.urlencode($page).'&edit=true">Edycja</a>';
    } else {
        $editLink = '';
    }
?>
<hr/>
<em>Data ostatniej modyfikacji: <?php echo $lastModified ?></em>
<?php echo $editLink ?> - <a href="<?php echo $_SERVER['SCRIPT_NAME'] ?>">Strona gwna</a>
</body>
</html>
<?php
}

// Wywietlenie formularza edycyjnego. Jeli strona ju istnieje, formularz zostanie 
// uzupeniony dotychczasow treci 
function edit($page, $isNew = false) {
    if ($isNew) { 
        $contents = '';
?>
<p><b>Strona nie zostaa jeszcze utworzona.</b> Aby j utworzy, wypenij pole treci i kliknij przycisk <b>Zapisz</b>.</p>
    <?php } else {
        $contents = file_get_contents(pageToFile($page));
    }
?>
<form method='post' action='<?php echo htmlentities($_SERVER['SCRIPT_NAME']) ?>'>
<input type='hidden' name='edit' value='true'/>
<input type='hidden' name='page' value='<?php echo htmlentities($page) ?>'/>
<textarea name='contents' rows='20' cols='60'>
<?php echo htmlentities($contents) ?></textarea>
<br/>
<input type='submit' value='Zapisz'/>
</form>
<?php
}
    
// Przeksztacenie przesanej strony w plik. Zastosowanie funkcji md5() stanowi 
// zabezpieczenie przed wystpieniem niedozwolonych znakw w zmiennej $page.
function pageToFile($page) {
    return PAGEDIR.'/'.md5($page);
}

// Przeksztacenie tekstu [co] w odsyacz HTML do strony Wiki "co".
function wikiLinks($page) {
    if (preg_match_all('/\[([^\]]+?)\]/', $page, $matches, PREG_SET_ORDER)) {
        foreach ($matches as $match) {
            $page = str_replace($match[0], '<a href="'.$_SERVER['SCRIPT_NAME'].
'?page='.urlencode($match[1]).'">'.htmlentities($match[1]).'</a>', $page);
        }
    }
    return $page;
}
?>
